-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.1.46


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


--
-- Create schema mythconverg
--

CREATE DATABASE IF NOT EXISTS mythconverg;
USE mythconverg;

--
-- Definition of table `callsignnetworkmap`
--

DROP TABLE IF EXISTS `callsignnetworkmap`;
CREATE TABLE `callsignnetworkmap` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `callsign` varchar(20) NOT NULL DEFAULT '',
  `network` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `callsign` (`callsign`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `callsignnetworkmap`
--

/*!40000 ALTER TABLE `callsignnetworkmap` DISABLE KEYS */;
/*!40000 ALTER TABLE `callsignnetworkmap` ENABLE KEYS */;


--
-- Definition of table `capturecard`
--

DROP TABLE IF EXISTS `capturecard`;
CREATE TABLE `capturecard` (
  `cardid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `videodevice` varchar(128) DEFAULT NULL,
  `audiodevice` varchar(128) DEFAULT NULL,
  `vbidevice` varchar(128) DEFAULT NULL,
  `cardtype` varchar(32) DEFAULT 'V4L',
  `defaultinput` varchar(32) DEFAULT 'Television',
  `audioratelimit` int(11) DEFAULT NULL,
  `hostname` varchar(64) DEFAULT NULL,
  `dvb_swfilter` int(11) DEFAULT '0',
  `dvb_sat_type` int(11) NOT NULL DEFAULT '0',
  `dvb_wait_for_seqstart` int(11) NOT NULL DEFAULT '1',
  `skipbtaudio` tinyint(1) DEFAULT '0',
  `dvb_on_demand` tinyint(4) NOT NULL DEFAULT '0',
  `dvb_diseqc_type` smallint(6) DEFAULT NULL,
  `firewire_speed` int(10) unsigned NOT NULL DEFAULT '0',
  `firewire_model` varchar(32) DEFAULT NULL,
  `firewire_connection` int(10) unsigned NOT NULL DEFAULT '0',
  `dbox2_port` int(10) unsigned NOT NULL DEFAULT '31338',
  `dbox2_httpport` int(10) unsigned NOT NULL DEFAULT '80',
  `dbox2_host` varchar(32) DEFAULT NULL,
  `signal_timeout` int(11) NOT NULL DEFAULT '1000',
  `channel_timeout` int(11) NOT NULL DEFAULT '3000',
  `dvb_tuning_delay` int(10) unsigned NOT NULL DEFAULT '0',
  `contrast` int(11) NOT NULL DEFAULT '0',
  `brightness` int(11) NOT NULL DEFAULT '0',
  `colour` int(11) NOT NULL DEFAULT '0',
  `hue` int(11) NOT NULL DEFAULT '0',
  `diseqcid` int(10) unsigned DEFAULT NULL,
  `dvb_eitscan` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`cardid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `capturecard`
--

/*!40000 ALTER TABLE `capturecard` DISABLE KEYS */;
/*!40000 ALTER TABLE `capturecard` ENABLE KEYS */;


--
-- Definition of table `cardinput`
--

DROP TABLE IF EXISTS `cardinput`;
CREATE TABLE `cardinput` (
  `cardinputid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cardid` int(10) unsigned NOT NULL DEFAULT '0',
  `sourceid` int(10) unsigned NOT NULL DEFAULT '0',
  `inputname` varchar(32) NOT NULL DEFAULT '',
  `externalcommand` varchar(128) DEFAULT NULL,
  `shareable` char(1) DEFAULT 'N',
  `tunechan` varchar(10) DEFAULT NULL,
  `startchan` varchar(10) DEFAULT NULL,
  `freetoaironly` tinyint(1) DEFAULT '1',
  `displayname` varchar(64) NOT NULL DEFAULT '',
  `radioservices` tinyint(1) DEFAULT '1',
  `dishnet_eit` tinyint(1) NOT NULL DEFAULT '0',
  `recpriority` int(11) NOT NULL DEFAULT '0',
  `quicktune` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cardinputid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `cardinput`
--

/*!40000 ALTER TABLE `cardinput` DISABLE KEYS */;
/*!40000 ALTER TABLE `cardinput` ENABLE KEYS */;


--
-- Definition of table `channel`
--

DROP TABLE IF EXISTS `channel`;
CREATE TABLE `channel` (
  `chanid` int(10) unsigned NOT NULL DEFAULT '0',
  `channum` varchar(10) NOT NULL DEFAULT '',
  `freqid` varchar(10) DEFAULT NULL,
  `sourceid` int(10) unsigned DEFAULT NULL,
  `callsign` varchar(20) NOT NULL DEFAULT '',
  `name` varchar(64) NOT NULL DEFAULT '',
  `icon` varchar(255) NOT NULL DEFAULT 'none',
  `finetune` int(11) DEFAULT NULL,
  `videofilters` varchar(255) NOT NULL DEFAULT '',
  `xmltvid` varchar(64) NOT NULL DEFAULT '',
  `recpriority` int(10) NOT NULL DEFAULT '0',
  `contrast` int(11) DEFAULT '32768',
  `brightness` int(11) DEFAULT '32768',
  `colour` int(11) DEFAULT '32768',
  `hue` int(11) DEFAULT '32768',
  `tvformat` varchar(10) NOT NULL DEFAULT 'Default',
  `visible` tinyint(1) NOT NULL DEFAULT '1',
  `outputfilters` varchar(255) NOT NULL DEFAULT '',
  `useonairguide` tinyint(1) DEFAULT '0',
  `mplexid` smallint(6) DEFAULT NULL,
  `serviceid` mediumint(8) unsigned DEFAULT NULL,
  `tmoffset` int(11) NOT NULL DEFAULT '0',
  `atsc_major_chan` int(10) unsigned NOT NULL DEFAULT '0',
  `atsc_minor_chan` int(10) unsigned NOT NULL DEFAULT '0',
  `last_record` datetime NOT NULL,
  `default_authority` varchar(32) NOT NULL DEFAULT '',
  `commmethod` int(11) NOT NULL DEFAULT '-1',
  PRIMARY KEY (`chanid`),
  KEY `channel_src` (`channum`,`sourceid`),
  KEY `sourceid` (`sourceid`,`xmltvid`,`chanid`),
  KEY `visible` (`visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `channel`
--

/*!40000 ALTER TABLE `channel` DISABLE KEYS */;
/*!40000 ALTER TABLE `channel` ENABLE KEYS */;


--
-- Definition of table `channelgroup`
--

DROP TABLE IF EXISTS `channelgroup`;
CREATE TABLE `channelgroup` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `chanid` int(11) unsigned NOT NULL DEFAULT '0',
  `grpid` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `channelgroup`
--

/*!40000 ALTER TABLE `channelgroup` DISABLE KEYS */;
/*!40000 ALTER TABLE `channelgroup` ENABLE KEYS */;


--
-- Definition of table `channelgroupnames`
--

DROP TABLE IF EXISTS `channelgroupnames`;
CREATE TABLE `channelgroupnames` (
  `grpid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL DEFAULT '0',
  PRIMARY KEY (`grpid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `channelgroupnames`
--

/*!40000 ALTER TABLE `channelgroupnames` DISABLE KEYS */;
/*!40000 ALTER TABLE `channelgroupnames` ENABLE KEYS */;


--
-- Definition of table `channelscan`
--

DROP TABLE IF EXISTS `channelscan`;
CREATE TABLE `channelscan` (
  `scanid` int(3) unsigned NOT NULL AUTO_INCREMENT,
  `cardid` int(3) unsigned NOT NULL,
  `sourceid` int(3) unsigned NOT NULL,
  `processed` tinyint(1) unsigned NOT NULL,
  `scandate` datetime NOT NULL,
  PRIMARY KEY (`scanid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `channelscan`
--

/*!40000 ALTER TABLE `channelscan` DISABLE KEYS */;
/*!40000 ALTER TABLE `channelscan` ENABLE KEYS */;


--
-- Definition of table `channelscan_channel`
--

DROP TABLE IF EXISTS `channelscan_channel`;
CREATE TABLE `channelscan_channel` (
  `transportid` int(6) unsigned NOT NULL,
  `scanid` int(3) unsigned NOT NULL,
  `mplex_id` smallint(6) NOT NULL,
  `source_id` int(3) unsigned NOT NULL,
  `channel_id` int(3) unsigned NOT NULL DEFAULT '0',
  `callsign` varchar(20) NOT NULL DEFAULT '',
  `service_name` varchar(64) NOT NULL DEFAULT '',
  `chan_num` varchar(10) NOT NULL DEFAULT '',
  `service_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `atsc_major_channel` int(4) unsigned NOT NULL DEFAULT '0',
  `atsc_minor_channel` int(4) unsigned NOT NULL DEFAULT '0',
  `use_on_air_guide` tinyint(1) NOT NULL DEFAULT '0',
  `hidden` tinyint(1) NOT NULL DEFAULT '0',
  `hidden_in_guide` tinyint(1) NOT NULL DEFAULT '0',
  `freqid` varchar(10) NOT NULL DEFAULT '',
  `icon` varchar(255) NOT NULL DEFAULT '',
  `tvformat` varchar(10) NOT NULL DEFAULT 'Default',
  `xmltvid` varchar(64) NOT NULL DEFAULT '',
  `pat_tsid` int(5) unsigned NOT NULL DEFAULT '0',
  `vct_tsid` int(5) unsigned NOT NULL DEFAULT '0',
  `vct_chan_tsid` int(5) unsigned NOT NULL DEFAULT '0',
  `sdt_tsid` int(5) unsigned NOT NULL DEFAULT '0',
  `orig_netid` int(5) unsigned NOT NULL DEFAULT '0',
  `netid` int(5) unsigned NOT NULL DEFAULT '0',
  `si_standard` varchar(10) NOT NULL,
  `in_channels_conf` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `in_pat` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `in_pmt` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `in_vct` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `in_nit` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `in_sdt` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_encrypted` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_data_service` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_audio_service` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_opencable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `could_be_opencable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `decryption_status` smallint(2) unsigned NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `channelscan_channel`
--

/*!40000 ALTER TABLE `channelscan_channel` DISABLE KEYS */;
/*!40000 ALTER TABLE `channelscan_channel` ENABLE KEYS */;


--
-- Definition of table `channelscan_dtv_multiplex`
--

DROP TABLE IF EXISTS `channelscan_dtv_multiplex`;
CREATE TABLE `channelscan_dtv_multiplex` (
  `transportid` int(6) unsigned NOT NULL AUTO_INCREMENT,
  `scanid` int(3) unsigned NOT NULL,
  `mplexid` smallint(6) unsigned NOT NULL,
  `frequency` bigint(12) unsigned NOT NULL,
  `inversion` char(1) NOT NULL DEFAULT 'a',
  `symbolrate` bigint(12) unsigned NOT NULL DEFAULT '0',
  `fec` varchar(4) NOT NULL DEFAULT 'auto',
  `polarity` char(1) NOT NULL DEFAULT '',
  `hp_code_rate` varchar(4) NOT NULL DEFAULT 'auto',
  `lp_code_rate` varchar(4) NOT NULL DEFAULT 'auto',
  `modulation` varchar(4) NOT NULL DEFAULT 'auto',
  `transmission_mode` char(1) NOT NULL DEFAULT 'a',
  `guard_interval` varchar(4) NOT NULL DEFAULT 'auto',
  `hierarchy` varchar(4) NOT NULL DEFAULT 'auto',
  `bandwidth` char(1) NOT NULL DEFAULT 'a',
  `sistandard` varchar(10) NOT NULL,
  `tuner_type` smallint(2) unsigned NOT NULL,
  PRIMARY KEY (`transportid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `channelscan_dtv_multiplex`
--

/*!40000 ALTER TABLE `channelscan_dtv_multiplex` DISABLE KEYS */;
/*!40000 ALTER TABLE `channelscan_dtv_multiplex` ENABLE KEYS */;


--
-- Definition of table `codecparams`
--

DROP TABLE IF EXISTS `codecparams`;
CREATE TABLE `codecparams` (
  `profile` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(128) NOT NULL DEFAULT '',
  `value` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`profile`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `codecparams`
--

/*!40000 ALTER TABLE `codecparams` DISABLE KEYS */;
/*!40000 ALTER TABLE `codecparams` ENABLE KEYS */;


--
-- Definition of table `credits`
--

DROP TABLE IF EXISTS `credits`;
CREATE TABLE `credits` (
  `person` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `chanid` int(10) unsigned NOT NULL DEFAULT '0',
  `starttime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `role` set('actor','director','producer','executive_producer','writer','guest_star','host','adapter','presenter','commentator','guest') NOT NULL DEFAULT '',
  UNIQUE KEY `chanid` (`chanid`,`starttime`,`person`,`role`),
  KEY `person` (`person`,`role`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `credits`
--

/*!40000 ALTER TABLE `credits` DISABLE KEYS */;
/*!40000 ALTER TABLE `credits` ENABLE KEYS */;


--
-- Definition of table `customexample`
--

DROP TABLE IF EXISTS `customexample`;
CREATE TABLE `customexample` (
  `rulename` varchar(64) NOT NULL,
  `fromclause` text NOT NULL,
  `whereclause` text NOT NULL,
  `search` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`rulename`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `customexample`
--

/*!40000 ALTER TABLE `customexample` DISABLE KEYS */;
INSERT INTO `customexample` (`rulename`,`fromclause`,`whereclause`,`search`) VALUES 
 ('New Flix','','program.category_type = \'movie\' AND program.airdate >= \n     YEAR(DATE_SUB(NOW(), INTERVAL 1 YEAR)) \nAND program.stars > 0.5 ',1);
/*!40000 ALTER TABLE `customexample` ENABLE KEYS */;


--
-- Definition of table `diseqc_config`
--

DROP TABLE IF EXISTS `diseqc_config`;
CREATE TABLE `diseqc_config` (
  `cardinputid` int(10) unsigned NOT NULL,
  `diseqcid` int(10) unsigned NOT NULL,
  `value` varchar(16) NOT NULL DEFAULT '',
  KEY `id` (`cardinputid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `diseqc_config`
--

/*!40000 ALTER TABLE `diseqc_config` DISABLE KEYS */;
/*!40000 ALTER TABLE `diseqc_config` ENABLE KEYS */;


--
-- Definition of table `diseqc_tree`
--

DROP TABLE IF EXISTS `diseqc_tree`;
CREATE TABLE `diseqc_tree` (
  `diseqcid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parentid` int(10) unsigned DEFAULT NULL,
  `ordinal` tinyint(3) unsigned NOT NULL,
  `type` varchar(16) NOT NULL DEFAULT '',
  `subtype` varchar(16) NOT NULL DEFAULT '',
  `description` varchar(32) NOT NULL DEFAULT '',
  `switch_ports` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `rotor_hi_speed` float NOT NULL DEFAULT '0',
  `rotor_lo_speed` float NOT NULL DEFAULT '0',
  `rotor_positions` varchar(255) NOT NULL DEFAULT '',
  `lnb_lof_switch` int(10) NOT NULL DEFAULT '0',
  `lnb_lof_hi` int(10) NOT NULL DEFAULT '0',
  `lnb_lof_lo` int(10) NOT NULL DEFAULT '0',
  `cmd_repeat` int(11) NOT NULL DEFAULT '1',
  `lnb_pol_inv` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`diseqcid`),
  KEY `parentid` (`parentid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `diseqc_tree`
--

/*!40000 ALTER TABLE `diseqc_tree` DISABLE KEYS */;
/*!40000 ALTER TABLE `diseqc_tree` ENABLE KEYS */;


--
-- Definition of table `displayprofilegroups`
--

DROP TABLE IF EXISTS `displayprofilegroups`;
CREATE TABLE `displayprofilegroups` (
  `name` varchar(128) NOT NULL,
  `hostname` varchar(64) NOT NULL,
  `profilegroupid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`name`,`hostname`),
  UNIQUE KEY `profilegroupid` (`profilegroupid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `displayprofilegroups`
--

/*!40000 ALTER TABLE `displayprofilegroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `displayprofilegroups` ENABLE KEYS */;


--
-- Definition of table `displayprofiles`
--

DROP TABLE IF EXISTS `displayprofiles`;
CREATE TABLE `displayprofiles` (
  `profilegroupid` int(10) unsigned NOT NULL,
  `profileid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `value` varchar(128) NOT NULL,
  `data` varchar(255) NOT NULL DEFAULT '',
  KEY `profilegroupid` (`profilegroupid`),
  KEY `profileid` (`profileid`,`value`),
  KEY `profileid_2` (`profileid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `displayprofiles`
--

/*!40000 ALTER TABLE `displayprofiles` DISABLE KEYS */;
/*!40000 ALTER TABLE `displayprofiles` ENABLE KEYS */;


--
-- Definition of table `dtv_multiplex`
--

DROP TABLE IF EXISTS `dtv_multiplex`;
CREATE TABLE `dtv_multiplex` (
  `mplexid` smallint(6) NOT NULL AUTO_INCREMENT,
  `sourceid` smallint(6) DEFAULT NULL,
  `transportid` int(11) DEFAULT NULL,
  `networkid` int(11) DEFAULT NULL,
  `frequency` int(11) DEFAULT NULL,
  `inversion` char(1) DEFAULT 'a',
  `symbolrate` int(11) DEFAULT NULL,
  `fec` varchar(10) DEFAULT 'auto',
  `polarity` char(1) DEFAULT NULL,
  `modulation` varchar(10) DEFAULT 'auto',
  `bandwidth` char(1) DEFAULT 'a',
  `lp_code_rate` varchar(10) DEFAULT 'auto',
  `transmission_mode` char(1) DEFAULT 'a',
  `guard_interval` varchar(10) DEFAULT 'auto',
  `visible` smallint(1) NOT NULL DEFAULT '0',
  `constellation` varchar(10) DEFAULT 'auto',
  `hierarchy` varchar(10) DEFAULT 'auto',
  `hp_code_rate` varchar(10) DEFAULT 'auto',
  `sistandard` varchar(10) DEFAULT 'dvb',
  `serviceversion` smallint(6) DEFAULT '33',
  `updatetimestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`mplexid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dtv_multiplex`
--

/*!40000 ALTER TABLE `dtv_multiplex` DISABLE KEYS */;
/*!40000 ALTER TABLE `dtv_multiplex` ENABLE KEYS */;


--
-- Definition of table `dtv_privatetypes`
--

DROP TABLE IF EXISTS `dtv_privatetypes`;
CREATE TABLE `dtv_privatetypes` (
  `sitype` varchar(4) NOT NULL DEFAULT '',
  `networkid` int(11) NOT NULL DEFAULT '0',
  `private_type` varchar(20) NOT NULL DEFAULT '',
  `private_value` varchar(100) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dtv_privatetypes`
--

/*!40000 ALTER TABLE `dtv_privatetypes` DISABLE KEYS */;
INSERT INTO `dtv_privatetypes` (`sitype`,`networkid`,`private_type`,`private_value`) VALUES 
 ('dvb',9018,'channel_numbers','131'),
 ('dvb',9018,'guide_fixup','2'),
 ('dvb',256,'guide_fixup','1'),
 ('dvb',257,'guide_fixup','1'),
 ('dvb',256,'tv_types','1,150,134,133'),
 ('dvb',257,'tv_types','1,150,134,133'),
 ('dvb',4100,'sdt_mapping','1'),
 ('dvb',4101,'sdt_mapping','1'),
 ('dvb',4102,'sdt_mapping','1'),
 ('dvb',4103,'sdt_mapping','1'),
 ('dvb',4104,'sdt_mapping','1'),
 ('dvb',4105,'sdt_mapping','1'),
 ('dvb',4106,'sdt_mapping','1'),
 ('dvb',4107,'sdt_mapping','1'),
 ('dvb',4097,'sdt_mapping','1'),
 ('dvb',4098,'sdt_mapping','1'),
 ('dvb',4100,'tv_types','1,145,154'),
 ('dvb',4101,'tv_types','1,145,154'),
 ('dvb',4102,'tv_types','1,145,154'),
 ('dvb',4103,'tv_types','1,145,154'),
 ('dvb',4104,'tv_types','1,145,154'),
 ('dvb',4105,'tv_types','1,145,154'),
 ('dvb',4106,'tv_types','1,145,154'),
 ('dvb',4107,'tv_types','1,145,154'),
 ('dvb',4097,'tv_types','1,145,154'),
 ('dvb',4098,'tv_types','1,145,154'),
 ('dvb',4100,'guide_fixup','1'),
 ('dvb',4101,'guide_fixup','1'),
 ('dvb',4102,'guide_fixup','1'),
 ('dvb',4103,'guide_fixup','1'),
 ('dvb',4104,'guide_fixup','1'),
 ('dvb',4105,'guide_fixup','1'),
 ('dvb',4106,'guide_fixup','1'),
 ('dvb',4107,'guide_fixup','1'),
 ('dvb',4096,'guide_fixup','5'),
 ('dvb',4097,'guide_fixup','1'),
 ('dvb',4098,'guide_fixup','1'),
 ('dvb',94,'tv_types','1,128'),
 ('atsc',1793,'guide_fixup','3'),
 ('dvb',40999,'guide_fixup','4'),
 ('dvb',70,'force_guide_present','yes'),
 ('dvb',70,'guide_ranges','80,80,96,96'),
 ('dvb',4112,'channel_numbers','131'),
 ('dvb',4115,'channel_numbers','131'),
 ('dvb',4116,'channel_numbers','131'),
 ('dvb',12802,'channel_numbers','131'),
 ('dvb',12803,'channel_numbers','131'),
 ('dvb',12829,'channel_numbers','131'),
 ('dvb',40999,'parse_subtitle_list','1070,1308,1041,1306,1307,1030,1016,1131,1068,1069'),
 ('dvb',4096,'guide_fixup','5');
/*!40000 ALTER TABLE `dtv_privatetypes` ENABLE KEYS */;


--
-- Definition of table `dvdbookmark`
--

DROP TABLE IF EXISTS `dvdbookmark`;
CREATE TABLE `dvdbookmark` (
  `serialid` varchar(16) NOT NULL DEFAULT '',
  `name` varchar(32) DEFAULT NULL,
  `title` smallint(6) NOT NULL DEFAULT '0',
  `audionum` tinyint(4) NOT NULL DEFAULT '-1',
  `subtitlenum` tinyint(4) NOT NULL DEFAULT '-1',
  `framenum` bigint(20) NOT NULL DEFAULT '0',
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`serialid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dvdbookmark`
--

/*!40000 ALTER TABLE `dvdbookmark` DISABLE KEYS */;
/*!40000 ALTER TABLE `dvdbookmark` ENABLE KEYS */;


--
-- Definition of table `eit_cache`
--

DROP TABLE IF EXISTS `eit_cache`;
CREATE TABLE `eit_cache` (
  `chanid` int(10) NOT NULL,
  `eventid` int(10) unsigned NOT NULL DEFAULT '0',
  `tableid` tinyint(3) unsigned NOT NULL,
  `version` tinyint(3) unsigned NOT NULL,
  `endtime` int(10) unsigned NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`chanid`,`eventid`,`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `eit_cache`
--

/*!40000 ALTER TABLE `eit_cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `eit_cache` ENABLE KEYS */;


--
-- Definition of table `housekeeping`
--

DROP TABLE IF EXISTS `housekeeping`;
CREATE TABLE `housekeeping` (
  `tag` varchar(64) NOT NULL DEFAULT '',
  `lastrun` datetime DEFAULT NULL,
  PRIMARY KEY (`tag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `housekeeping`
--

/*!40000 ALTER TABLE `housekeeping` DISABLE KEYS */;
INSERT INTO `housekeeping` (`tag`,`lastrun`) VALUES 
 ('BackupDB','2011-08-10 07:26:02');
/*!40000 ALTER TABLE `housekeeping` ENABLE KEYS */;


--
-- Definition of table `inputgroup`
--

DROP TABLE IF EXISTS `inputgroup`;
CREATE TABLE `inputgroup` (
  `cardinputid` int(10) unsigned NOT NULL,
  `inputgroupid` int(10) unsigned NOT NULL,
  `inputgroupname` varchar(32) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `inputgroup`
--

/*!40000 ALTER TABLE `inputgroup` DISABLE KEYS */;
/*!40000 ALTER TABLE `inputgroup` ENABLE KEYS */;


--
-- Definition of table `inuseprograms`
--

DROP TABLE IF EXISTS `inuseprograms`;
CREATE TABLE `inuseprograms` (
  `chanid` int(10) unsigned NOT NULL DEFAULT '0',
  `starttime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `recusage` varchar(128) NOT NULL DEFAULT '',
  `lastupdatetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hostname` varchar(64) NOT NULL DEFAULT '',
  `rechost` varchar(64) NOT NULL,
  `recdir` varchar(255) NOT NULL DEFAULT '',
  KEY `chanid` (`chanid`,`starttime`),
  KEY `recusage` (`recusage`,`lastupdatetime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `inuseprograms`
--

/*!40000 ALTER TABLE `inuseprograms` DISABLE KEYS */;
/*!40000 ALTER TABLE `inuseprograms` ENABLE KEYS */;


--
-- Definition of table `jobqueue`
--

DROP TABLE IF EXISTS `jobqueue`;
CREATE TABLE `jobqueue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `chanid` int(10) NOT NULL DEFAULT '0',
  `starttime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `inserttime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `type` int(11) NOT NULL DEFAULT '0',
  `cmds` int(11) NOT NULL DEFAULT '0',
  `flags` int(11) NOT NULL DEFAULT '0',
  `status` int(11) NOT NULL DEFAULT '0',
  `statustime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `hostname` varchar(64) NOT NULL DEFAULT '',
  `args` blob NOT NULL,
  `comment` varchar(128) NOT NULL DEFAULT '',
  `schedruntime` datetime NOT NULL DEFAULT '2007-01-01 00:00:00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `chanid` (`chanid`,`starttime`,`type`,`inserttime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `jobqueue`
--

/*!40000 ALTER TABLE `jobqueue` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobqueue` ENABLE KEYS */;


--
-- Definition of table `jumppoints`
--

DROP TABLE IF EXISTS `jumppoints`;
CREATE TABLE `jumppoints` (
  `destination` varchar(128) NOT NULL DEFAULT '',
  `description` varchar(255) DEFAULT NULL,
  `keylist` varchar(128) DEFAULT NULL,
  `hostname` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`destination`,`hostname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `jumppoints`
--

/*!40000 ALTER TABLE `jumppoints` DISABLE KEYS */;
/*!40000 ALTER TABLE `jumppoints` ENABLE KEYS */;


--
-- Definition of table `keybindings`
--

DROP TABLE IF EXISTS `keybindings`;
CREATE TABLE `keybindings` (
  `context` varchar(32) NOT NULL DEFAULT '',
  `action` varchar(32) NOT NULL DEFAULT '',
  `description` varchar(255) DEFAULT NULL,
  `keylist` varchar(128) DEFAULT NULL,
  `hostname` varchar(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`context`,`action`,`hostname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `keybindings`
--

/*!40000 ALTER TABLE `keybindings` DISABLE KEYS */;
INSERT INTO `keybindings` (`context`,`action`,`description`,`keylist`,`hostname`) VALUES 
 ('Global','UP','Up Arrow','Up','nythtv03'),
 ('Global','DOWN','Down Arrow','Down','nythtv03'),
 ('Global','LEFT','Left Arrow','Left','nythtv03'),
 ('Global','RIGHT','Right Arrow','Right','nythtv03'),
 ('Global','NEXT','Move to next widget','Tab','nythtv03'),
 ('Global','PREVIOUS','Move to preview widget','Backtab','nythtv03'),
 ('Global','SELECT','Select','Return,Enter,Space','nythtv03'),
 ('Global','BACKSPACE','Backspace','Backspace','nythtv03'),
 ('Global','ESCAPE','Escape','Esc','nythtv03'),
 ('Global','MENU','Pop-up menu','M','nythtv03'),
 ('Global','INFO','More information','I','nythtv03'),
 ('Global','DELETE','Delete','D','nythtv03'),
 ('Global','EDIT','Edit','E','nythtv03'),
 ('Global','SCREENSHOT','Save screenshot','','nythtv03'),
 ('Global','HANDLEMEDIA','Play a media resource','','nythtv03'),
 ('Global','PAGEUP','Page Up','PgUp','nythtv03'),
 ('Global','PAGEDOWN','Page Down','PgDown','nythtv03'),
 ('Global','PAGETOP','Page to top of list','','nythtv03'),
 ('Global','PAGEMIDDLE','Page to middle of list','','nythtv03'),
 ('Global','PAGEBOTTOM','Page to bottom of list','','nythtv03'),
 ('Global','PREVVIEW','Previous View','Home','nythtv03'),
 ('Global','NEXTVIEW','Next View','End','nythtv03'),
 ('Global','HELP','Help','F1','nythtv03'),
 ('Global','EJECT','Eject Removable Media','','nythtv03'),
 ('Global','CUT','Cut text from textedit','Ctrl+X','nythtv03'),
 ('Global','COPY','Copy text from textedit','Ctrl+C','nythtv03'),
 ('Global','PASTE','Paste text into textedit','Ctrl+V','nythtv03'),
 ('Global','UNDO','Undo','Ctrl+Z','nythtv03'),
 ('Global','REDO','Redo','Ctrl+Y','nythtv03'),
 ('Global','SEARCH','Show incremental search dialog','Ctrl+S','nythtv03'),
 ('Global','0','0','0','nythtv03'),
 ('Global','1','1','1','nythtv03'),
 ('Global','2','2','2','nythtv03'),
 ('Global','3','3','3','nythtv03'),
 ('Global','4','4','4','nythtv03'),
 ('Global','5','5','5','nythtv03'),
 ('Global','6','6','6','nythtv03'),
 ('Global','7','7','7','nythtv03'),
 ('Global','8','8','8','nythtv03'),
 ('Global','9','9','9','nythtv03'),
 ('Global','SYSEVENT01','Trigger System Key Event #1','','nythtv03'),
 ('Global','SYSEVENT02','Trigger System Key Event #2','','nythtv03'),
 ('Global','SYSEVENT03','Trigger System Key Event #3','','nythtv03'),
 ('Global','SYSEVENT04','Trigger System Key Event #4','','nythtv03'),
 ('Global','SYSEVENT05','Trigger System Key Event #5','','nythtv03'),
 ('Global','SYSEVENT06','Trigger System Key Event #6','','nythtv03'),
 ('Global','SYSEVENT07','Trigger System Key Event #7','','nythtv03'),
 ('Global','SYSEVENT08','Trigger System Key Event #8','','nythtv03'),
 ('Global','SYSEVENT09','Trigger System Key Event #9','','nythtv03'),
 ('Global','SYSEVENT10','Trigger System Key Event #10','','nythtv03'),
 ('Browser','ZOOMIN','Zoom in on browser window','.,>','nythtv03'),
 ('Browser','ZOOMOUT','Zoom out on browser window',',,<','nythtv03'),
 ('Browser','TOGGLEINPUT','Toggle where keyboard input goes to','F1','nythtv03'),
 ('Browser','MOUSEUP','Move mouse pointer up','2','nythtv03'),
 ('Browser','MOUSEDOWN','Move mouse pointer down','8','nythtv03'),
 ('Browser','MOUSELEFT','Move mouse pointer left','4','nythtv03'),
 ('Browser','MOUSERIGHT','Move mouse pointer right','6','nythtv03'),
 ('Browser','MOUSELEFTBUTTON','Mouse Left button click','5','nythtv03'),
 ('Browser','PAGEDOWN','Scroll down half a page','9','nythtv03'),
 ('Browser','PAGEUP','Scroll up half a page','3','nythtv03'),
 ('Browser','PAGELEFT','Scroll left half a page','7','nythtv03'),
 ('Browser','PAGERIGHT','Scroll right half a page','1','nythtv03'),
 ('Browser','NEXTLINK','Move selection to next link','Z','nythtv03'),
 ('Browser','PREVIOUSLINK','Move selection to previous link','Q','nythtv03'),
 ('Browser','FOLLOWLINK','Follow selected link','Return,Space,Enter','nythtv03'),
 ('Browser','HISTORYBACK','Go back to previous page','R,Backspace','nythtv03'),
 ('Browser','HISTORYFORWARD','Go forward to previous page','F','nythtv03'),
 ('Main Menu','EXIT','System Exit','','nythtv03'),
 ('Main Menu','EXITPROMPT','Display System Exit Prompt','Esc','nythtv03');
/*!40000 ALTER TABLE `keybindings` ENABLE KEYS */;


--
-- Definition of table `keyword`
--

DROP TABLE IF EXISTS `keyword`;
CREATE TABLE `keyword` (
  `phrase` varchar(128) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `searchtype` int(10) unsigned NOT NULL DEFAULT '3',
  UNIQUE KEY `phrase` (`phrase`,`searchtype`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `keyword`
--

/*!40000 ALTER TABLE `keyword` DISABLE KEYS */;
/*!40000 ALTER TABLE `keyword` ENABLE KEYS */;


--
-- Definition of table `mythlog`
--

DROP TABLE IF EXISTS `mythlog`;
CREATE TABLE `mythlog` (
  `logid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(32) NOT NULL DEFAULT '',
  `priority` int(11) NOT NULL DEFAULT '0',
  `acknowledged` tinyint(1) DEFAULT '0',
  `logdate` datetime DEFAULT NULL,
  `host` varchar(128) DEFAULT NULL,
  `message` varchar(255) NOT NULL DEFAULT '',
  `details` text,
  PRIMARY KEY (`logid`),
  KEY `module` (`module`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `mythlog`
--

/*!40000 ALTER TABLE `mythlog` DISABLE KEYS */;
/*!40000 ALTER TABLE `mythlog` ENABLE KEYS */;


--
-- Definition of table `networkiconmap`
--

DROP TABLE IF EXISTS `networkiconmap`;
CREATE TABLE `networkiconmap` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `network` varchar(20) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `network` (`network`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `networkiconmap`
--

/*!40000 ALTER TABLE `networkiconmap` DISABLE KEYS */;
/*!40000 ALTER TABLE `networkiconmap` ENABLE KEYS */;


--
-- Definition of table `oldfind`
--

DROP TABLE IF EXISTS `oldfind`;
CREATE TABLE `oldfind` (
  `recordid` int(11) NOT NULL DEFAULT '0',
  `findid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`recordid`,`findid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `oldfind`
--

/*!40000 ALTER TABLE `oldfind` DISABLE KEYS */;
/*!40000 ALTER TABLE `oldfind` ENABLE KEYS */;


--
-- Definition of table `oldprogram`
--

DROP TABLE IF EXISTS `oldprogram`;
CREATE TABLE `oldprogram` (
  `oldtitle` varchar(128) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `airdate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`oldtitle`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `oldprogram`
--

/*!40000 ALTER TABLE `oldprogram` DISABLE KEYS */;
/*!40000 ALTER TABLE `oldprogram` ENABLE KEYS */;


--
-- Definition of table `oldrecorded`
--

DROP TABLE IF EXISTS `oldrecorded`;
CREATE TABLE `oldrecorded` (
  `chanid` int(10) unsigned NOT NULL DEFAULT '0',
  `starttime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `endtime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `title` varchar(128) NOT NULL DEFAULT '',
  `subtitle` varchar(128) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `category` varchar(64) NOT NULL DEFAULT '',
  `seriesid` varchar(40) NOT NULL DEFAULT '',
  `programid` varchar(40) NOT NULL DEFAULT '',
  `findid` int(11) NOT NULL DEFAULT '0',
  `recordid` int(11) NOT NULL DEFAULT '0',
  `station` varchar(20) NOT NULL DEFAULT '',
  `rectype` int(10) unsigned NOT NULL DEFAULT '0',
  `duplicate` tinyint(1) NOT NULL DEFAULT '0',
  `recstatus` int(11) NOT NULL DEFAULT '0',
  `reactivate` smallint(6) NOT NULL DEFAULT '0',
  `generic` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`station`,`starttime`,`title`),
  KEY `endtime` (`endtime`),
  KEY `title` (`title`),
  KEY `seriesid` (`seriesid`),
  KEY `programid` (`programid`),
  KEY `recordid` (`recordid`),
  KEY `recstatus` (`recstatus`,`programid`,`seriesid`),
  KEY `recstatus_2` (`recstatus`,`title`,`subtitle`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `oldrecorded`
--

/*!40000 ALTER TABLE `oldrecorded` DISABLE KEYS */;
/*!40000 ALTER TABLE `oldrecorded` ENABLE KEYS */;


--
-- Definition of table `people`
--

DROP TABLE IF EXISTS `people`;
CREATE TABLE `people` (
  `person` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`person`),
  UNIQUE KEY `name` (`name`(41))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `people`
--

/*!40000 ALTER TABLE `people` DISABLE KEYS */;
/*!40000 ALTER TABLE `people` ENABLE KEYS */;


--
-- Definition of table `pidcache`
--

DROP TABLE IF EXISTS `pidcache`;
CREATE TABLE `pidcache` (
  `chanid` smallint(6) NOT NULL DEFAULT '0',
  `pid` int(11) NOT NULL DEFAULT '-1',
  `tableid` int(11) NOT NULL DEFAULT '-1',
  KEY `chanid` (`chanid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `pidcache`
--

/*!40000 ALTER TABLE `pidcache` DISABLE KEYS */;
/*!40000 ALTER TABLE `pidcache` ENABLE KEYS */;


--
-- Definition of table `playgroup`
--

DROP TABLE IF EXISTS `playgroup`;
CREATE TABLE `playgroup` (
  `name` varchar(32) NOT NULL DEFAULT '',
  `titlematch` varchar(255) NOT NULL DEFAULT '',
  `skipahead` int(11) NOT NULL DEFAULT '0',
  `skipback` int(11) NOT NULL DEFAULT '0',
  `timestretch` int(11) NOT NULL DEFAULT '0',
  `jump` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `playgroup`
--

/*!40000 ALTER TABLE `playgroup` DISABLE KEYS */;
INSERT INTO `playgroup` (`name`,`titlematch`,`skipahead`,`skipback`,`timestretch`,`jump`) VALUES 
 ('Default','',30,5,100,0);
/*!40000 ALTER TABLE `playgroup` ENABLE KEYS */;


--
-- Definition of table `powerpriority`
--

DROP TABLE IF EXISTS `powerpriority`;
CREATE TABLE `powerpriority` (
  `priorityname` varchar(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `recpriority` int(10) NOT NULL DEFAULT '0',
  `selectclause` text NOT NULL,
  PRIMARY KEY (`priorityname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `powerpriority`
--

/*!40000 ALTER TABLE `powerpriority` DISABLE KEYS */;
/*!40000 ALTER TABLE `powerpriority` ENABLE KEYS */;


--
-- Definition of table `profilegroups`
--

DROP TABLE IF EXISTS `profilegroups`;
CREATE TABLE `profilegroups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) DEFAULT NULL,
  `cardtype` varchar(32) NOT NULL DEFAULT 'V4L',
  `is_default` int(1) DEFAULT '0',
  `hostname` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`hostname`),
  KEY `cardtype` (`cardtype`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `profilegroups`
--

/*!40000 ALTER TABLE `profilegroups` DISABLE KEYS */;
INSERT INTO `profilegroups` (`id`,`name`,`cardtype`,`is_default`,`hostname`) VALUES 
 (1,'Software Encoders (v4l based)','V4L',1,NULL),
 (2,'IVTV MPEG-2 Encoders','MPEG',1,NULL),
 (3,'Hardware MJPEG Encoders (Matrox G200-TV, Miro DC10, etc)','MJPEG',1,NULL),
 (4,'Hardware HDTV','HDTV',1,NULL),
 (5,'Hardware DVB Encoders','DVB',1,NULL),
 (6,'Transcoders','TRANSCODE',1,NULL),
 (7,'FireWire Input','FIREWIRE',1,NULL),
 (8,'USB Mpeg-4 Encoder (Plextor ConvertX, etc)','GO7007',1,NULL),
 (9,'DBOX2 Input','DBOX2',1,NULL),
 (10,'Freebox Input','Freebox',1,NULL),
 (11,'HDHomeRun Recorders','HDHOMERUN',1,NULL),
 (12,'CRC IP Recorders','CRC_IP',1,NULL),
 (13,'HD-PVR Recorders','HDPVR',1,NULL);
/*!40000 ALTER TABLE `profilegroups` ENABLE KEYS */;


--
-- Definition of table `program`
--

DROP TABLE IF EXISTS `program`;
CREATE TABLE `program` (
  `chanid` int(10) unsigned NOT NULL DEFAULT '0',
  `starttime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `endtime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `title` varchar(128) NOT NULL DEFAULT '',
  `subtitle` varchar(128) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `category` varchar(64) NOT NULL DEFAULT '',
  `category_type` varchar(64) NOT NULL DEFAULT '',
  `airdate` year(4) NOT NULL DEFAULT '0000',
  `stars` float NOT NULL DEFAULT '0',
  `previouslyshown` tinyint(4) NOT NULL DEFAULT '0',
  `title_pronounce` varchar(128) NOT NULL DEFAULT '',
  `stereo` tinyint(1) NOT NULL DEFAULT '0',
  `subtitled` tinyint(1) NOT NULL DEFAULT '0',
  `hdtv` tinyint(1) NOT NULL DEFAULT '0',
  `closecaptioned` tinyint(1) NOT NULL DEFAULT '0',
  `partnumber` int(11) NOT NULL DEFAULT '0',
  `parttotal` int(11) NOT NULL DEFAULT '0',
  `seriesid` varchar(40) NOT NULL DEFAULT '',
  `originalairdate` date DEFAULT NULL,
  `showtype` varchar(30) NOT NULL DEFAULT '',
  `colorcode` varchar(20) NOT NULL DEFAULT '',
  `syndicatedepisodenumber` varchar(20) NOT NULL DEFAULT '',
  `programid` varchar(40) NOT NULL DEFAULT '',
  `manualid` int(10) unsigned NOT NULL DEFAULT '0',
  `generic` tinyint(1) DEFAULT '0',
  `listingsource` int(11) NOT NULL DEFAULT '0',
  `first` tinyint(1) NOT NULL DEFAULT '0',
  `last` tinyint(1) NOT NULL DEFAULT '0',
  `audioprop` set('STEREO','MONO','SURROUND','DOLBY','HARDHEAR','VISUALIMPAIR') NOT NULL,
  `subtitletypes` set('HARDHEAR','NORMAL','ONSCREEN','SIGNED') NOT NULL,
  `videoprop` set('HDTV','WIDESCREEN','AVC') NOT NULL,
  PRIMARY KEY (`chanid`,`starttime`,`manualid`),
  KEY `endtime` (`endtime`),
  KEY `title` (`title`),
  KEY `title_pronounce` (`title_pronounce`),
  KEY `seriesid` (`seriesid`),
  KEY `id_start_end` (`chanid`,`starttime`,`endtime`),
  KEY `program_manualid` (`manualid`),
  KEY `previouslyshown` (`previouslyshown`),
  KEY `programid` (`programid`,`starttime`),
  KEY `starttime` (`starttime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `program`
--

/*!40000 ALTER TABLE `program` DISABLE KEYS */;
/*!40000 ALTER TABLE `program` ENABLE KEYS */;


--
-- Definition of table `programgenres`
--

DROP TABLE IF EXISTS `programgenres`;
CREATE TABLE `programgenres` (
  `chanid` int(10) unsigned NOT NULL DEFAULT '0',
  `starttime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `relevance` char(1) NOT NULL DEFAULT '',
  `genre` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`chanid`,`starttime`,`relevance`),
  KEY `genre` (`genre`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `programgenres`
--

/*!40000 ALTER TABLE `programgenres` DISABLE KEYS */;
/*!40000 ALTER TABLE `programgenres` ENABLE KEYS */;


--
-- Definition of table `programrating`
--

DROP TABLE IF EXISTS `programrating`;
CREATE TABLE `programrating` (
  `chanid` int(10) unsigned NOT NULL DEFAULT '0',
  `starttime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `system` varchar(8) DEFAULT NULL,
  `rating` varchar(16) DEFAULT NULL,
  UNIQUE KEY `chanid` (`chanid`,`starttime`,`system`,`rating`),
  KEY `starttime` (`starttime`,`system`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `programrating`
--

/*!40000 ALTER TABLE `programrating` DISABLE KEYS */;
/*!40000 ALTER TABLE `programrating` ENABLE KEYS */;


--
-- Definition of table `recgrouppassword`
--

DROP TABLE IF EXISTS `recgrouppassword`;
CREATE TABLE `recgrouppassword` (
  `recgroup` varchar(32) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `password` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`recgroup`),
  UNIQUE KEY `recgroup` (`recgroup`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `recgrouppassword`
--

/*!40000 ALTER TABLE `recgrouppassword` DISABLE KEYS */;
/*!40000 ALTER TABLE `recgrouppassword` ENABLE KEYS */;


--
-- Definition of table `record`
--

DROP TABLE IF EXISTS `record`;
CREATE TABLE `record` (
  `recordid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  `chanid` int(10) unsigned DEFAULT NULL,
  `starttime` time NOT NULL DEFAULT '00:00:00',
  `startdate` date NOT NULL DEFAULT '0000-00-00',
  `endtime` time NOT NULL DEFAULT '00:00:00',
  `enddate` date NOT NULL DEFAULT '0000-00-00',
  `title` varchar(128) NOT NULL DEFAULT '',
  `subtitle` varchar(128) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `category` varchar(64) NOT NULL DEFAULT '',
  `profile` varchar(128) NOT NULL DEFAULT 'Default',
  `recpriority` int(10) NOT NULL DEFAULT '0',
  `autoexpire` int(11) NOT NULL DEFAULT '0',
  `maxepisodes` int(11) NOT NULL DEFAULT '0',
  `maxnewest` int(11) NOT NULL DEFAULT '0',
  `startoffset` int(11) NOT NULL DEFAULT '0',
  `endoffset` int(11) NOT NULL DEFAULT '0',
  `recgroup` varchar(32) NOT NULL DEFAULT 'Default',
  `dupmethod` int(11) NOT NULL DEFAULT '6',
  `dupin` int(11) NOT NULL DEFAULT '15',
  `station` varchar(20) NOT NULL DEFAULT '',
  `seriesid` varchar(40) NOT NULL DEFAULT '',
  `programid` varchar(40) NOT NULL DEFAULT '',
  `search` int(10) unsigned NOT NULL DEFAULT '0',
  `autotranscode` tinyint(1) NOT NULL DEFAULT '0',
  `autocommflag` tinyint(1) NOT NULL DEFAULT '0',
  `autouserjob1` tinyint(1) NOT NULL DEFAULT '0',
  `autouserjob2` tinyint(1) NOT NULL DEFAULT '0',
  `autouserjob3` tinyint(1) NOT NULL DEFAULT '0',
  `autouserjob4` tinyint(1) NOT NULL DEFAULT '0',
  `findday` tinyint(4) NOT NULL DEFAULT '0',
  `findtime` time NOT NULL DEFAULT '00:00:00',
  `findid` int(11) NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT '0',
  `parentid` int(11) NOT NULL DEFAULT '0',
  `transcoder` int(11) NOT NULL DEFAULT '0',
  `tsdefault` float NOT NULL DEFAULT '1',
  `playgroup` varchar(32) NOT NULL DEFAULT 'Default',
  `prefinput` int(10) NOT NULL DEFAULT '0',
  `next_record` datetime NOT NULL,
  `last_record` datetime NOT NULL,
  `last_delete` datetime NOT NULL,
  `storagegroup` varchar(32) NOT NULL DEFAULT 'Default',
  `avg_delay` int(11) NOT NULL DEFAULT '100',
  PRIMARY KEY (`recordid`),
  KEY `chanid` (`chanid`,`starttime`),
  KEY `title` (`title`),
  KEY `seriesid` (`seriesid`),
  KEY `programid` (`programid`),
  KEY `maxepisodes` (`maxepisodes`),
  KEY `search` (`search`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `record`
--

/*!40000 ALTER TABLE `record` DISABLE KEYS */;
/*!40000 ALTER TABLE `record` ENABLE KEYS */;


--
-- Definition of table `recorded`
--

DROP TABLE IF EXISTS `recorded`;
CREATE TABLE `recorded` (
  `chanid` int(10) unsigned NOT NULL DEFAULT '0',
  `starttime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `endtime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `title` varchar(128) NOT NULL DEFAULT '',
  `subtitle` varchar(128) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `category` varchar(64) NOT NULL DEFAULT '',
  `hostname` varchar(64) NOT NULL DEFAULT '',
  `bookmark` tinyint(1) NOT NULL DEFAULT '0',
  `editing` int(10) unsigned NOT NULL DEFAULT '0',
  `cutlist` tinyint(1) NOT NULL DEFAULT '0',
  `autoexpire` int(11) NOT NULL DEFAULT '0',
  `commflagged` int(10) unsigned NOT NULL DEFAULT '0',
  `recgroup` varchar(32) NOT NULL DEFAULT 'Default',
  `recordid` int(11) DEFAULT NULL,
  `seriesid` varchar(40) NOT NULL DEFAULT '',
  `programid` varchar(40) NOT NULL DEFAULT '',
  `lastmodified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `filesize` bigint(20) NOT NULL DEFAULT '0',
  `stars` float NOT NULL DEFAULT '0',
  `previouslyshown` tinyint(1) DEFAULT '0',
  `originalairdate` date DEFAULT NULL,
  `preserve` tinyint(1) NOT NULL DEFAULT '0',
  `findid` int(11) NOT NULL DEFAULT '0',
  `deletepending` tinyint(1) NOT NULL DEFAULT '0',
  `transcoder` int(11) NOT NULL DEFAULT '0',
  `timestretch` float NOT NULL DEFAULT '1',
  `recpriority` int(11) NOT NULL DEFAULT '0',
  `basename` varchar(255) NOT NULL,
  `progstart` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `progend` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `playgroup` varchar(32) NOT NULL DEFAULT 'Default',
  `profile` varchar(32) NOT NULL DEFAULT '',
  `duplicate` tinyint(1) NOT NULL DEFAULT '0',
  `transcoded` tinyint(1) NOT NULL DEFAULT '0',
  `watched` tinyint(4) NOT NULL DEFAULT '0',
  `storagegroup` varchar(32) NOT NULL DEFAULT 'Default',
  PRIMARY KEY (`chanid`,`starttime`),
  KEY `endtime` (`endtime`),
  KEY `seriesid` (`seriesid`),
  KEY `programid` (`programid`),
  KEY `title` (`title`),
  KEY `recordid` (`recordid`),
  KEY `deletepending` (`deletepending`,`lastmodified`),
  KEY `recgroup` (`recgroup`,`endtime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `recorded`
--

/*!40000 ALTER TABLE `recorded` DISABLE KEYS */;
/*!40000 ALTER TABLE `recorded` ENABLE KEYS */;


--
-- Definition of table `recordedcredits`
--

DROP TABLE IF EXISTS `recordedcredits`;
CREATE TABLE `recordedcredits` (
  `person` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `chanid` int(10) unsigned NOT NULL DEFAULT '0',
  `starttime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `role` set('actor','director','producer','executive_producer','writer','guest_star','host','adapter','presenter','commentator','guest') NOT NULL DEFAULT '',
  UNIQUE KEY `chanid` (`chanid`,`starttime`,`person`,`role`),
  KEY `person` (`person`,`role`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `recordedcredits`
--

/*!40000 ALTER TABLE `recordedcredits` DISABLE KEYS */;
/*!40000 ALTER TABLE `recordedcredits` ENABLE KEYS */;


--
-- Definition of table `recordedfile`
--

DROP TABLE IF EXISTS `recordedfile`;
CREATE TABLE `recordedfile` (
  `chanid` int(10) unsigned NOT NULL DEFAULT '0',
  `starttime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `basename` varchar(128) NOT NULL DEFAULT '',
  `filesize` bigint(20) NOT NULL DEFAULT '0',
  `width` smallint(5) unsigned NOT NULL DEFAULT '0',
  `height` smallint(5) unsigned NOT NULL DEFAULT '0',
  `fps` float(6,3) NOT NULL DEFAULT '0.000',
  `aspect` float(8,6) NOT NULL DEFAULT '0.000000',
  `audio_sample_rate` smallint(5) unsigned NOT NULL DEFAULT '0',
  `audio_bits_per_sample` smallint(5) unsigned NOT NULL DEFAULT '0',
  `audio_channels` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `audio_type` varchar(255) NOT NULL DEFAULT '',
  `video_type` varchar(255) NOT NULL DEFAULT '',
  `comment` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`chanid`,`starttime`),
  KEY `basename` (`basename`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `recordedfile`
--

/*!40000 ALTER TABLE `recordedfile` DISABLE KEYS */;
/*!40000 ALTER TABLE `recordedfile` ENABLE KEYS */;


--
-- Definition of table `recordedmarkup`
--

DROP TABLE IF EXISTS `recordedmarkup`;
CREATE TABLE `recordedmarkup` (
  `chanid` int(10) unsigned NOT NULL DEFAULT '0',
  `starttime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `mark` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(4) NOT NULL DEFAULT '0',
  `data` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`chanid`,`starttime`,`type`,`mark`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `recordedmarkup`
--

/*!40000 ALTER TABLE `recordedmarkup` DISABLE KEYS */;
/*!40000 ALTER TABLE `recordedmarkup` ENABLE KEYS */;


--
-- Definition of table `recordedprogram`
--

DROP TABLE IF EXISTS `recordedprogram`;
CREATE TABLE `recordedprogram` (
  `chanid` int(10) unsigned NOT NULL DEFAULT '0',
  `starttime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `endtime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `title` varchar(128) NOT NULL DEFAULT '',
  `subtitle` varchar(128) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `category` varchar(64) NOT NULL DEFAULT '',
  `category_type` varchar(64) NOT NULL DEFAULT '',
  `airdate` year(4) NOT NULL DEFAULT '0000',
  `stars` float unsigned NOT NULL DEFAULT '0',
  `previouslyshown` tinyint(4) NOT NULL DEFAULT '0',
  `title_pronounce` varchar(128) NOT NULL DEFAULT '',
  `stereo` tinyint(1) NOT NULL DEFAULT '0',
  `subtitled` tinyint(1) NOT NULL DEFAULT '0',
  `hdtv` tinyint(1) NOT NULL DEFAULT '0',
  `closecaptioned` tinyint(1) NOT NULL DEFAULT '0',
  `partnumber` int(11) NOT NULL DEFAULT '0',
  `parttotal` int(11) NOT NULL DEFAULT '0',
  `seriesid` varchar(40) NOT NULL DEFAULT '',
  `originalairdate` date DEFAULT NULL,
  `showtype` varchar(30) NOT NULL DEFAULT '',
  `colorcode` varchar(20) NOT NULL DEFAULT '',
  `syndicatedepisodenumber` varchar(20) NOT NULL DEFAULT '',
  `programid` varchar(40) NOT NULL DEFAULT '',
  `manualid` int(10) unsigned NOT NULL DEFAULT '0',
  `generic` tinyint(1) DEFAULT '0',
  `listingsource` int(11) NOT NULL DEFAULT '0',
  `first` tinyint(1) NOT NULL DEFAULT '0',
  `last` tinyint(1) NOT NULL DEFAULT '0',
  `audioprop` set('STEREO','MONO','SURROUND','DOLBY','HARDHEAR','VISUALIMPAIR') NOT NULL,
  `subtitletypes` set('HARDHEAR','NORMAL','ONSCREEN','SIGNED') NOT NULL,
  `videoprop` set('HDTV','WIDESCREEN','AVC') NOT NULL,
  PRIMARY KEY (`chanid`,`starttime`,`manualid`),
  KEY `endtime` (`endtime`),
  KEY `title` (`title`),
  KEY `title_pronounce` (`title_pronounce`),
  KEY `seriesid` (`seriesid`),
  KEY `programid` (`programid`),
  KEY `id_start_end` (`chanid`,`starttime`,`endtime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `recordedprogram`
--

/*!40000 ALTER TABLE `recordedprogram` DISABLE KEYS */;
/*!40000 ALTER TABLE `recordedprogram` ENABLE KEYS */;


--
-- Definition of table `recordedrating`
--

DROP TABLE IF EXISTS `recordedrating`;
CREATE TABLE `recordedrating` (
  `chanid` int(10) unsigned NOT NULL DEFAULT '0',
  `starttime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `system` varchar(8) DEFAULT NULL,
  `rating` varchar(16) DEFAULT NULL,
  UNIQUE KEY `chanid` (`chanid`,`starttime`,`system`,`rating`),
  KEY `starttime` (`starttime`,`system`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `recordedrating`
--

/*!40000 ALTER TABLE `recordedrating` DISABLE KEYS */;
/*!40000 ALTER TABLE `recordedrating` ENABLE KEYS */;


--
-- Definition of table `recordedseek`
--

DROP TABLE IF EXISTS `recordedseek`;
CREATE TABLE `recordedseek` (
  `chanid` int(10) unsigned NOT NULL DEFAULT '0',
  `starttime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `mark` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `offset` bigint(20) unsigned NOT NULL,
  `type` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`chanid`,`starttime`,`type`,`mark`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `recordedseek`
--

/*!40000 ALTER TABLE `recordedseek` DISABLE KEYS */;
/*!40000 ALTER TABLE `recordedseek` ENABLE KEYS */;


--
-- Definition of table `recordingprofiles`
--

DROP TABLE IF EXISTS `recordingprofiles`;
CREATE TABLE `recordingprofiles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) DEFAULT NULL,
  `videocodec` varchar(128) DEFAULT NULL,
  `audiocodec` varchar(128) DEFAULT NULL,
  `profilegroup` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `profilegroup` (`profilegroup`)
) ENGINE=MyISAM AUTO_INCREMENT=54 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `recordingprofiles`
--

/*!40000 ALTER TABLE `recordingprofiles` DISABLE KEYS */;
INSERT INTO `recordingprofiles` (`id`,`name`,`videocodec`,`audiocodec`,`profilegroup`) VALUES 
 (1,'Default',NULL,NULL,1),
 (2,'Live TV',NULL,NULL,1),
 (3,'High Quality',NULL,NULL,1),
 (4,'Low Quality',NULL,NULL,1),
 (5,'Default',NULL,NULL,2),
 (6,'Live TV',NULL,NULL,2),
 (7,'High Quality',NULL,NULL,2),
 (8,'Low Quality',NULL,NULL,2),
 (9,'Default',NULL,NULL,3),
 (10,'Live TV',NULL,NULL,3),
 (11,'High Quality',NULL,NULL,3),
 (12,'Low Quality',NULL,NULL,3),
 (13,'Default',NULL,NULL,4),
 (14,'Live TV',NULL,NULL,4),
 (15,'High Quality',NULL,NULL,4),
 (16,'Low Quality',NULL,NULL,4),
 (17,'Default',NULL,NULL,5),
 (18,'Live TV',NULL,NULL,5),
 (19,'High Quality',NULL,NULL,5),
 (20,'Low Quality',NULL,NULL,5),
 (21,'RTjpeg/MPEG4',NULL,NULL,6),
 (22,'MPEG2',NULL,NULL,6),
 (23,'Default',NULL,NULL,8),
 (24,'Live TV',NULL,NULL,8),
 (25,'High Quality',NULL,NULL,8),
 (26,'Low Quality',NULL,NULL,8),
 (27,'High Quality',NULL,NULL,6),
 (28,'Medium Quality',NULL,NULL,6),
 (29,'Low Quality',NULL,NULL,6),
 (30,'Default',NULL,NULL,10),
 (31,'Live TV',NULL,NULL,10),
 (32,'High Quality',NULL,NULL,10),
 (33,'Low Quality',NULL,NULL,10),
 (34,'Default',NULL,NULL,11),
 (35,'Live TV',NULL,NULL,11),
 (36,'High Quality',NULL,NULL,11),
 (37,'Low Quality',NULL,NULL,11),
 (38,'Default',NULL,NULL,12),
 (39,'Live TV',NULL,NULL,12),
 (40,'High Quality',NULL,NULL,12),
 (41,'Low Quality',NULL,NULL,12),
 (42,'Default',NULL,NULL,7),
 (43,'Live TV',NULL,NULL,7),
 (44,'High Quality',NULL,NULL,7),
 (45,'Low Quality',NULL,NULL,7),
 (46,'Default',NULL,NULL,9),
 (47,'Live TV',NULL,NULL,9),
 (48,'High Quality',NULL,NULL,9),
 (49,'Low Quality',NULL,NULL,9),
 (50,'Default',NULL,NULL,13),
 (51,'Live TV',NULL,NULL,13),
 (52,'High Quality',NULL,NULL,13),
 (53,'Low Quality',NULL,NULL,13);
/*!40000 ALTER TABLE `recordingprofiles` ENABLE KEYS */;


--
-- Definition of table `recordmatch`
--

DROP TABLE IF EXISTS `recordmatch`;
CREATE TABLE `recordmatch` (
  `recordid` int(10) unsigned DEFAULT NULL,
  `chanid` int(10) unsigned DEFAULT NULL,
  `starttime` datetime DEFAULT NULL,
  `manualid` int(10) unsigned DEFAULT NULL,
  `oldrecduplicate` tinyint(1) DEFAULT NULL,
  `recduplicate` tinyint(1) DEFAULT NULL,
  `findduplicate` tinyint(1) DEFAULT NULL,
  `oldrecstatus` int(11) DEFAULT NULL,
  KEY `recordid` (`recordid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `recordmatch`
--

/*!40000 ALTER TABLE `recordmatch` DISABLE KEYS */;
/*!40000 ALTER TABLE `recordmatch` ENABLE KEYS */;


--
-- Definition of table `schemalock`
--

DROP TABLE IF EXISTS `schemalock`;
CREATE TABLE `schemalock` (
  `schemalock` int(1) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `schemalock`
--

/*!40000 ALTER TABLE `schemalock` DISABLE KEYS */;
/*!40000 ALTER TABLE `schemalock` ENABLE KEYS */;


--
-- Definition of table `settings`
--

DROP TABLE IF EXISTS `settings`;
CREATE TABLE `settings` (
  `value` varchar(128) NOT NULL DEFAULT '',
  `data` text,
  `hostname` varchar(64) DEFAULT NULL,
  KEY `value` (`value`,`hostname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `settings`
--

/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` (`value`,`data`,`hostname`) VALUES 
 ('mythfilldatabaseLastRunStart',NULL,NULL),
 ('mythfilldatabaseLastRunEnd',NULL,NULL),
 ('mythfilldatabaseLastRunStatus',NULL,NULL),
 ('DataDirectMessage',NULL,NULL),
 ('HaveRepeats','0',NULL),
 ('DBSchemaVer','1226',NULL),
 ('DefaultTranscoder','0',NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;


--
-- Definition of table `storagegroup`
--

DROP TABLE IF EXISTS `storagegroup`;
CREATE TABLE `storagegroup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupname` varchar(32) NOT NULL,
  `hostname` varchar(64) NOT NULL DEFAULT '',
  `dirname` varchar(235) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `grouphostdir` (`groupname`,`hostname`,`dirname`),
  KEY `hostname` (`hostname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `storagegroup`
--

/*!40000 ALTER TABLE `storagegroup` DISABLE KEYS */;
/*!40000 ALTER TABLE `storagegroup` ENABLE KEYS */;


--
-- Definition of table `tvchain`
--

DROP TABLE IF EXISTS `tvchain`;
CREATE TABLE `tvchain` (
  `chanid` int(10) unsigned NOT NULL DEFAULT '0',
  `starttime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `chainid` varchar(128) NOT NULL DEFAULT '',
  `chainpos` int(10) NOT NULL DEFAULT '0',
  `discontinuity` tinyint(1) NOT NULL DEFAULT '0',
  `watching` int(10) NOT NULL DEFAULT '0',
  `hostprefix` varchar(128) NOT NULL DEFAULT '',
  `cardtype` varchar(32) NOT NULL DEFAULT 'V4L',
  `input` varchar(32) NOT NULL DEFAULT '',
  `channame` varchar(32) NOT NULL DEFAULT '',
  `endtime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`chanid`,`starttime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `tvchain`
--

/*!40000 ALTER TABLE `tvchain` DISABLE KEYS */;
/*!40000 ALTER TABLE `tvchain` ENABLE KEYS */;


--
-- Definition of table `upnpmedia`
--

DROP TABLE IF EXISTS `upnpmedia`;
CREATE TABLE `upnpmedia` (
  `intid` int(10) unsigned NOT NULL DEFAULT '0',
  `class` varchar(64) NOT NULL DEFAULT '',
  `itemtype` varchar(128) NOT NULL DEFAULT '',
  `parentid` int(10) unsigned NOT NULL DEFAULT '0',
  `itemproperties` varchar(255) NOT NULL DEFAULT '',
  `filepath` varchar(512) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `filename` varchar(512) NOT NULL DEFAULT '',
  `coverart` varchar(512) NOT NULL DEFAULT '',
  PRIMARY KEY (`intid`),
  KEY `class` (`class`),
  KEY `filepath` (`filepath`(333)),
  KEY `parentid` (`parentid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `upnpmedia`
--

/*!40000 ALTER TABLE `upnpmedia` DISABLE KEYS */;
/*!40000 ALTER TABLE `upnpmedia` ENABLE KEYS */;


--
-- Definition of table `videosource`
--

DROP TABLE IF EXISTS `videosource`;
CREATE TABLE `videosource` (
  `sourceid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL DEFAULT '',
  `xmltvgrabber` varchar(128) DEFAULT NULL,
  `userid` varchar(128) NOT NULL DEFAULT '',
  `freqtable` varchar(16) NOT NULL DEFAULT 'default',
  `lineupid` varchar(64) DEFAULT NULL,
  `password` varchar(64) DEFAULT NULL,
  `useeit` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`sourceid`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `videosource`
--

/*!40000 ALTER TABLE `videosource` DISABLE KEYS */;
/*!40000 ALTER TABLE `videosource` ENABLE KEYS */;




/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
